<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Student extends Model 
{

    protected $table = 'Students';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'mobile', 'gender_id', 'personal_id', 'age', 'address', 'status');

    public function genderRelation()
    {
        return $this->belongsTo('App\Models\Gender', 'gender_id');
    }

    public function studentClassroomRelation()
    {
        return $this->belongsToMany('App\Models\Classroom', 'Classroom_Student');
    }

}